package w83b.w83bOperacionesPaso.w83bCitaciones;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesRTF;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bAcuseCitacionAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
		ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		HashMap txtMuniProv=(HashMap)contexto.get("w83bMapResultadosBean");
		
		HashMap plantillas=(HashMap)contexto.get("w83bPlantillasMap");
		W83bPlantillasBean plantilla=(W83bPlantillasBean)plantillas.get(W83bClsConstantes.ACUSES.toUpperCase());
		
		HashMap mapaPar = new HashMap();
		W83bCitacionBean citacion=(W83bCitacionBean)contexto.get("w83bCitacionDetalleBean");
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
		HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	    StringBuffer  tituloDelelegacionEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
		StringBuffer  tituloDelelegacionEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
		StringBuffer  tituloDepEu = (StringBuffer)datosDelDep.get("tituloDepEu");
		StringBuffer  tituloDepEs = (StringBuffer)datosDelDep.get("tituloDepEs");
		
		String cp="";
		String munic="";
		
		//se rellenan los datos que se van a repetir continuamente para no tener que rellenar por cada elemento
		
			mapaPar.put("<<DEPEUS>>",tituloDepEu.toString());
			mapaPar.put("<<DEPCAS>>",tituloDepEs.toString());
			mapaPar.put("<<DELEUS>>",tituloDelelegacionEu.toString());
			mapaPar.put("<<DELCAS>>",tituloDelelegacionEs.toString());
			mapaPar.put("<<DELDIR>>",W83bUtilidadesComunes.obtenerCalledelegacionFormateada(usuario).toString());
			String codigopostal="";
			if(StringUtils.isNotEmpty(usuario.getCodigoPostalDelegacion())){
				
				codigopostal=usuario.getCodigoPostalDelegacion();
			}
			mapaPar.put("<<DELCP>>",codigopostal);
		
			if (citacion.getNacta().charAt(0)=='a'){
				mapaPar.put("<<NENTR>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",idioma)+": "+citacion.getNacta().substring(1,citacion.getNacta().length()));
			}
			else{
				mapaPar.put("<<NENTR>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preaviso",idioma)+": "+citacion.getNacta().substring(1,citacion.getNacta().length()));
			}
		
			mapaPar.put("<<finrep>>","");
			mapaPar.put("<<iniciorep>>","");
			CharSequence content=W83bUtilidadesRTF.leerTodoFichero(plantilla.getFichero());
			
			String contenido=content.toString();
			
			
			//calculo de coger el trozo que nos interesa repetir
			
			/*la idea es coger el contenido anterior al trozo a repetir le llamaremos "PREV" 
			/* el trozo a repetri "TROZO"
			 * y la parte trasera del contenido "POST"
			 * 
			 * Nuestro contenido final contentra "PREV" + n veces TROZO + "POST"
			 */
			StringBuffer contenidoBuffer=new StringBuffer(contenido);
			
			int y=contenidoBuffer.indexOf("<<iniciorep>>");
			int z=contenidoBuffer.indexOf("<<finrep>>")+15;
			
			String parteDelante=contenido.substring(0,y);
			String parteDetras=contenido.substring(z,contenido.length());
			int inicio=parteDelante.lastIndexOf("{");
			int fin=parteDetras.indexOf("}")+1+z;
			String parteDelanteLimpia=contenido.substring(0,inicio);
			String parteAtrasLimpia=contenido.substring(fin,contenido.length());
			
			
			
			String saltos="\r\n\\par \r\n\\par \r\n\\par ";
			int inicioSaltos=contenidoBuffer.lastIndexOf(saltos);
			StringBuffer contenidoBufferCorto=new StringBuffer(contenidoBuffer.toString());
			contenidoBufferCorto.replace(inicioSaltos,inicioSaltos+saltos.length(),"");
			
		StringBuffer datos=new StringBuffer();
		// se aade la parte delantera del documento.
		datos.append(parteDelanteLimpia);
		StringBuffer elemento=new StringBuffer(W83bClsConstantes.CUARENTA);	
		//Se van a aniadir N elementos, que corresponden a las partes afectadas de la citacion
		int numElem=1;
		if(citacion.getCentroSel().equals(W83bClsConstantes.CONSTANTE_NO_VALIDADA))
		{
			
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getRazonSocial()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getDomicilio()));
			cp=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getCodPostal());
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getMunicipio());
			if (!cp.trim().equals("")&&!munic.trim().equals("")){
				munic="-"+munic;//NOPMD;
			}
			mapaPar.put("<<LOCAL>>",munic);
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getTerritorio()));
		}else if(citacion.getCentroSel().equals(W83bClsConstantes.CONSTANTE_VALIDADA))
		{
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getRazonSocial()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getDomicilio()));
			cp=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getCodPostal());
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getMunicipio());
			if (!cp.trim().equals("")&&!munic.trim().equals("")){
				munic="-"+munic;//NOPMD;
			}
			mapaPar.put("<<LOCAL>>",munic);
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getTerritorio()));
		}
		mapaPar.put("<<NUMNOTIF>>",String.valueOf(numElem));
		elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
		datos.append(elemento);
		//por el centro
		numElem++;
		if(citacion.getMesa().equals(W83bClsConstantes.CONSTANTE_VALIDADA))
		{
			mapaPar.put("<<RAZON>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.comunicacion.mesaElectoral",idioma));
			//resto del mapa es el mismo que la empresa
			mapaPar.put("<<NUMNOTIF>>",String.valueOf(numElem));
			elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			datos.append(elemento);
			numElem++;
		}
		if(StringUtils.isNotEmpty(citacion.getDniImpug()))
			
		{  	
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getNombreImpug()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getDirImpug()));
			cp=W83bUtilidades.convertirAVasioSiNulo(citacion.getCpImpug());
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNulo(citacion.getMunicipioImpugTxtC());
			if (!cp.trim().equals("")&&!munic.trim().equals("")){
				munic="-"+munic;//NOPMD;
			}
			mapaPar.put("<<LOCAL>>",munic);
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getProvinciaImpugTxtC()));
			mapaPar.put("<<NUMNOTIF>>",String.valueOf(numElem));
			
			// si es el elemento es el 3 multiple de 3 hay que retocar el contenido
			//quitar 7 saltos de linea
			
			if(numElem%3==0)
			{
				
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBufferCorto, mapaPar);
				
			}else{
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			}
			
			
			datos.append(elemento);
			numElem++;
			
		}
		String [] cods=citacion.getCodsSindicatos().split(",");
		String [] siglas=citacion.getSiglasSindicatos().split(", ");
		String [] dir=citacion.getDirSindicatos().split(",");
		String [] cps=citacion.getCpSindicatos().split(",");
		String [] munisC=(String[])txtMuniProv.get("txtMunicipiosC");
		String [] provsC=(String[])txtMuniProv.get("txtTerritoriosC");
		
		
		
		for(int i=0;i<cods.length;i++)
		{
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(siglas[i]));
			
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNuloArray(dir,i));
			cp=W83bUtilidades.convertirAVasioSiNuloArray(cps,i);
			mapaPar.put("<<CPOST>>",cp);
			munic=W83bUtilidades.convertirAVasioSiNuloArray(munisC,i);
			if (!("").equals(cp.trim())&&!("").equals(munic.trim())){
				mapaPar.put("<<LOCAL>>","-"+munic);
			}
			else{
				mapaPar.put("<<LOCAL>>",munic);
			}
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNuloArray(provsC,i));
			mapaPar.put("<<NUMNOTIF>>",String.valueOf(numElem));
			
			if(numElem%3==0)
			{
				
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBufferCorto, mapaPar);
				
			}else{
				elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			}
			
			
		
			datos.append(elemento);
			numElem++;
		}
		
				
		//para cerrar el contenido del documento metemos la parte trasera.
		datos.append(parteAtrasLimpia);
		
        response.setContentType("application/msword");
        response.setContentLength(datos.toString().getBytes().length);
        response.setHeader("Content-disposition","attachment;filename="+plantilla.getNombrePlantilla().replaceAll("[.]","CITACION."));
        response.getOutputStream().write(datos.toString().getBytes());
        response.getOutputStream().flush();

		
		return null;
	}
	
		
}

